# 触发器

SmartMarket 公司的OA数据库中包含以下结构：

```sql
create table employee(
    id serial primary key ,
    name varchar(256),
    dept varchar(64),
    salary decimal(12, 4)
);

create table budget(
    id serial primary key ,
    dept varchar(64),
    amount decimal(12, 4)
)
```

我们省略了无关的内容。当某个员工的工资发生变动时，我们要修改他所在部门的预算。那么以下哪个选项可以解决问题？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

在 employee 表添加一个 after 触发器，当员工信息变动时，重算相关部门的预算。

## 选项

### A

在 budget 表添加触发器，当员工信息变动时，重算相关部门的预算。

### B

将预算总额字段变成计算列，通过统计员工工资生成。

### C

将员工信息表的工资字段设置为部门预算总额的外键引用字段，并设置级联更新。